<?php
    include("../../shared/common.php");

    if(!isset($_SESSION['id']) || $_SESSION['role']!=='manager'){
        echo "<script type='text/javascript'>
            window.location = '../index';
        </script>";
    }
    
    $managerid = $_SESSION['id'];
    $active = 'questions';

    //Getting Business Id
    $query = "SELECT business FROM manager WHERE id=$managerid";
	$result = $db->query($query);
	$selectrow = mysqli_fetch_array($result);
    $businessid = $selectrow['business'];

?>

<html>
    <head>
	<link rel="shortcut icon" href="../../shared/logos/wereview_icon.png">
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width,initial-scale=1">
        <meta name="description" content="WeReview System" />
        <link rel="preconnect" href="https://fonts.gstatic.com" />
        <title>WeReview System</title>
        <link href="../../shared/css/app.css" rel="stylesheet" />
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <link href="assets/css/popup.css" rel="stylesheet" />
        <link href="assets/css/draggable.css" rel="stylesheet" />
    </head>
    
    <body>
        <div class="wrapper">
            <?php 
                include('includes/sidebar.php');
            ?>
            <div class="main">
            <?php 
                include('includes/header.php');
            ?>
            <main class="content">
                <div class="container-fluid p-0">
                    <div class="d-flex mb-4 justify-content-between align-items-center">
                        <h3><strong>Questions</strong></h3>
                    </div>
                    <div class="card w-100">
                        <div class="card-body px-4 w-100">
                            <input type="text" id="businessid" name="businessid" value="<?php echo $businessid;?>" hidden>
                            
                            <div id="questions-container"></div>

                            <form id="add-question-form" class="bg-light p-3 mt-3">
                                <input type="text" id="add-question-id" name="add-question-id" hidden>
                                <div class="row justify-items-between gap-4 gap-md-0 mb-3">
                                    <div class="col-md-6">
                                        <label for="add-question-text" class="mb-2">Question:</label>
                                        <input type="text" id="add-question-text" name="add-question-text" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="add-arabic-version" class="mb-2">Arabic Version:</label>
                                        <input type="text" id="add-arabic-version" name="add-arabic-version" class="form-control" required>
                                    </div>
                                </div>
                                <div class="row justify-items-between gap-4 gap-md-0 mb-3">
                                    <div class="col-md-3">
                                        <label for="add-question-type" class="mb-2">Question Type:</label>
                                        <select id="add-question-type" name="add-question-type" class="form-select" required>
                                            <?php
                                                $sql ="SELECT id, name FROM question_type";
                                                $result = $db->query($sql);
                                                if($result){
                                                    $nbline = mysqli_num_rows($result);
                                                    for($i=0;$i<$nbline;$i++) {
                                                        $line=mysqli_fetch_row($result);
                                                            echo"<option value=".$line[0].">".$line[1]."</option>";
                                                    }
                                                }
                                            ?>
                                        </select>
                                    </div>
                                    <div class="col-md-1 d-flex align-items-end">
                                        <div class="d-flex gap-2" style="font-size: 15px;">
                                            <input type="checkbox" id="add-question-active" class="form-check-input"> 
                                            <span>Active</span> 
                                        </div>
                                    </div>
                                    <div class="col-md-1 d-flex align-items-end">
                                        <div class="d-flex gap-2" style="font-size: 15px;">
                                            <input type="checkbox" id="add-question-required" class="form-check-input"> 
                                            <span>Required</span> 
                                        </div>
                                    </div>
                                </div>
                                <div class="row justify-items-between gap-4 gap-md-0 my-3" id="add-multiple-answers" style="display:none;">
                                    <?php for($i=1; $i<6; $i++){ ?>
                                        <div class="col-md-4 mb-3">
                                            <label class="mb-1">Answer <?php echo $i; ?></label>
                                            <input type="text" id="add-answer-en-<?php echo $i; ?>" class="form-control add-answer-en" name="add-answer-en-<?php echo $i; ?>">
                                        </div>
                                    <?php } ?>
                                    <?php for($i=1; $i<6; $i++){ ?>
                                        <div class="col-md-4 mb-3">
                                            <label class="mb-1">Arabic Answer <?php echo $i; ?></label>
                                            <input type="text" id="add-answer-ar-<?php echo $i; ?>" class="form-control add-answer-ar" name="add-answer-ar-<?php echo $i; ?>">
                                        </div>
                                    <?php } ?>
                                </div>
                                <button id="add-question-submit" type="submit" class="btn btn-lg btn-primary text-center">Add Question</button>
                            </form>

                            <div class="modal-overlay"></div>
                            <div class="modal-parent">
                                <div class="modal">
                                    <div class="modal-content">
                                        <form id="edit-question-form">
                                            <input type="text" id="edit-question-id" name="edit-question-id" hidden>
                                            <div class="mb-3">
                                                <label for="edit-question-text" class="mb-2">Question:</label>
                                                <input type="text" id="edit-question-text" name="edit-question-text" class="form-control" required>
                                            </div>
                                            <div class="mb-3">
                                                <label for="edit-arabic-version" class="mb-2">Arabic Version:</label>
                                                <input type="text" id="edit-arabic-version" name="edit-arabic-version" class="form-control" required>
                                            </div>
                                            <div class="mb-3">
                                                <label for="edit-question-type" class="mb-2">Question Type:</label>
                                                <select id="edit-question-type" name="edit-question-type" class="form-select" required>
                                                    <?php
                                                        $sql ="SELECT id, name FROM question_type";
                                                        $result = $db->query($sql);
                                                        if($result){
                                                            $nbline = mysqli_num_rows($result);
                                                            for($i=0;$i<$nbline;$i++) {
                                                                $line=mysqli_fetch_row($result);
                                                                    echo"<option value=".$line[0].">".$line[1]."</option>";
                                                            }
                                                        }
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="mb-3">
                                                <div class="d-flex gap-2 align-items-center" style="font-size: 15px;">
                                                    <input type="checkbox" id="edit-question-active" class="form-check-input mt-0"> 
                                                    <span>Active</span> 
                                                </div>
                                            </div>
                                            <div class="mb-3">
                                                <div class="d-flex gap-2 align-items-center" style="font-size: 15px;">
                                                    <input type="checkbox" id="edit-question-required" class="form-check-input mt-0"> 
                                                    <span>Required</span> 
                                                </div>
                                            </div>
                                            <div class="row justify-items-between gap-4 gap-md-0 my-3" id="edit-multiple-answers" style="display:none;">
                                                <?php for($i=1; $i<6; $i++){ ?>
                                                    <div class="col-md-4 mb-3">
                                                        <label class="mb-1">Answer <?php echo $i; ?></label>
                                                        <input type="text" id="edit-answer-en-<?php echo $i; ?>" class="form-control edit-answer-en" name="edit-answer-en-<?php echo $i; ?>">
                                                    </div>
                                                <?php } ?>
                                                <?php for($i=1; $i<6; $i++){ ?>
                                                    <div class="col-md-4 mb-3">
                                                        <label class="mb-1">Arabic Answer <?php echo $i; ?></label>
                                                        <input type="text" id="edit-answer-ar-<?php echo $i; ?>" class="form-control edit-answer-ar" name="edit-answer-ar-<?php echo $i; ?>">
                                                    </div>
                                                <?php } ?>
                                            </div>

                                            <button id="edit-question-submit" type="submit" class="btn btn-lg btn-primary text-center">Save Changes</button>
                                        </form>
                                    </div>
                                    <span class="x" draggable="true">&times;</span>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </main>
            <?php 
                include('includes/footer.php');
            ?> 
            </div>
        </div>
        
        <script src="../../shared/js/app.js"></script>
        <script src="assets/js/questions.js"></script>
        
    </body>
</html>
