<?php

	include("../../shared/common.php");

    if(!isset($_SESSION['id']) || $_SESSION['role']!=='manager'){
        echo "<script type='text/javascript'>
            window.location = '../index';
        </script>";
    }
    
    $managerid = $_SESSION['id'];
    $active = 'dashboard';

?>

<html>
    <head>
	<link rel="shortcut icon" href="../../shared/logos/wereview_icon.png">
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width,initial-scale=1">
        <meta name="description" content="WeReview System" />
        <link rel="preconnect" href="https://fonts.gstatic.com" />
        <title>WeReview System</title>
        <link href="../../shared/css/app.css" rel="stylesheet" />
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    </head>
    
    <body>
        <div class="wrapper">
            <?php 
                include('includes/sidebar.php');
            ?>
            <div class="main">
            <?php 
                include('includes/header.php');
            ?>
            <main class="content d-flex flex-column justify-content-center align-items-center gap-4">
				<input type="text" id="businessid" name="businessid" value="<?php echo $businessid;?>" hidden>
                <!--First Row-->
                <div class="row w-100 justify-content-center">
					<div class="col-xl-6 col-xxl-5">
                        <div class="card w-100">
                            <div class="card-header">
                                <h5 class="card-big-title">Application's Link</h5>
                            </div>
                            <div class="card-body d-flex align-items-center gap-4">
                                <div class="d-flex">
                                    <a href="https://quickchart.io/qr?text=https://we-review.com/app?business=<?php echo $businessid; ?>" target="_blank">
                                        <img height="100px" width="100px" src="https://quickchart.io/qr?text=https://we-review.com/app?business=<?php echo $businessid; ?>" title="App QR Code" />
                                        <!--<div style="text-align: center">Click to download</div>-->
                                    </a>
                                </div>
                                <div class="card-app-link">
                                    <a href="https://we-review.com/app?business=<?php echo $businessid; ?>" target="_blank">https://we-review.com/app?business=<?php echo $businessid; ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!--Second Row-->
                <div class="row w-100">

					<div class="col-xl-6 col-xxl-5 d-flex">
						<div class="w-100">
							<div class="row">

								<div class="col-sm-6">
								<div class="card">
										<div class="card-body">
											<div class="row">
												<div class="col mt-0">
													<h5 class="card-title">Total Reviews</h5>
												</div>
												<div class="col-auto">
													<div class="stat text-primary">
														<i class="align-middle" data-feather="star"></i>
													</div>
												</div>
											</div>
											<h1 class="mt-1 mb-3">
												<?php 
													$sql="SELECT customer FROM review WHERE business=$businessid GROUP BY customer, datetime ";
													$result = $db->query($sql);
													$count = $db->numRows($result);
													echo $count;
												?>
											</h1>
										</div>
									</div>
									<div class="card">
										<div class="card-body">
											<div class="row">
												<div class="col mt-0">
													<h5 class="card-title">Total Customers</h5>
												</div>

												<div class="col-auto">
													<div class="stat text-primary">
														<i class="align-middle" data-feather="users"></i>
													</div>
												</div>
											</div>
											<h1 class="mt-1 mb-3">
												<?php 
													$sql="SELECT DISTINCT customer FROM review WHERE business=$businessid";
													$result = $db->query($sql);
													$count = $db->numRows($result);
													echo $count;
												?>
											</h1>
										</div>
									</div>
								</div>

								<div class="col-sm-6">
									<div class="card">
										<div class="card-body">
											<div class="row">
												<div class="col mt-0">
													<h5 class="card-title">Monthly Reviews</h5>
												</div>
												<div class="col-auto">
													<div class="stat text-primary">
														<i class="align-middle" data-feather="star"></i>
													</div>
												</div>
											</div>
											<h1 class="mt-1 mb-3">
												<?php 
													$sql="SELECT customer FROM review WHERE business=$businessid AND MONTH(datetime) = MONTH(CURRENT_DATE()) AND YEAR(datetime) = YEAR(CURRENT_DATE()) GROUP BY customer, datetime ";
													$result = $db->query($sql);
													$count = $db->numRows($result);
													echo $count;
												?>
											</h1>
										</div>
									</div>
									<div class="card">
										<div class="card-body">
											<div class="row">
												<div class="col mt-0">
													<h5 class="card-title">Monthly Customers</h5>
												</div>

												<div class="col-auto">
													<div class="stat text-primary">
														<i class="align-middle" data-feather="users"></i>
													</div>
												</div>
											</div>
											<h1 class="mt-1 mb-3">
												<?php 
													$sql="SELECT DISTINCT customer
													FROM review
													WHERE business = $businessid
													AND MONTH(datetime) = MONTH(CURRENT_DATE())
													AND YEAR(datetime) = YEAR(CURRENT_DATE())
													AND customer NOT IN (
														SELECT DISTINCT customer
														FROM review
														WHERE business = $businessid
														AND YEAR(datetime) = YEAR(CURRENT_DATE())
														AND MONTH(datetime) < MONTH(CURRENT_DATE())
													);";
													$result = $db->query($sql);
													$count = $db->numRows($result);
													echo $count;
												?>
											</h1>
										</div>
									</div>
								</div>

							</div>
						</div>
					</div>

					<div class="col-xl-6 col-xxl-7 d-flex">
						<div class="card flex-fill w-100">
							<div class="card-header">
								<h5 class="card-title mb-0">Recent Movement</h5>
							</div>
							<div class="card-body py-3">
								<div class="chart chart-sm">
									<canvas id="reviews-bars"></canvas>
								</div>
							</div>
						</div>
					</div>

				</div>

				<!--Third Row-->
                <div class="w-100 d-flex flex-wrap justify-content-center align-items-center gap-4 py-5">
					<div class="d-flex align-items-center gap-2">
						<label>From:</label>
						<input type="date" class="form-control" id="start_date" name="start_date" value="">
					</div>

					<div class="d-flex align-items-center gap-2">
						<label>To:</label>
						<input type="date" class="form-control" id="end_date" name="end_date" value="">
					</div>

					<button type="button" class="btn btn-lg btn-primary text-center" id="apply_filter">Apply Filter</button>
				</div>

				<!--Fourth Row-->
                <div class="row w-100">

					<div class="col-xl-6 d-flex">
						<div class="card flex-fill w-100">
							<div class="card-header">
								<h5 class="card-title mb-0">Rating Questions</h5>
							</div>
							<div class="card-body py-3" id="rating_table"></div>
						</div>
					</div>

					<div class="col-xl-6 d-flex">
						<div class="card flex-fill w-100">
							<div class="card-header">
								<h5 class="card-title mb-0">Boolean Questions</h5>
							</div>
							<div class="card-body py-3" id="boolean_table"></div>
						</div>
					</div>

				</div>

				<!--Fifth Row-->
                <div class="row w-100">

					<div class="col-xl-6 d-flex">
						<div class="card flex-fill w-100">
							<div class="card-header">
								<h5 class="card-title mb-0">Customers by Gender</h5>
							</div>
							<div class="card-body py-3">
								<canvas id="gender_pie" width="100%" height="300"></canvas>
							</div>
						</div>
					</div>

					<div class="col-xl-6 d-flex">
						<div class="card flex-fill w-100">
							<div class="card-header">
								<h5 class="card-title mb-0">Customers by Age</h5>
							</div>
							<div class="card-body py-3">
								<canvas id="age_bars" width="100%" height="300"></canvas>
							</div>
						</div>
					</div>

				</div>
					
            </main>
            <?php 
                include('includes/footer.php');
            ?> 
        </div>
        
        <script src="../../shared/js/app.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
		<script src="assets/js/dashboard.js"></script>
        
    </body>
</html>
