$(document).ready(function() {
    let business = $("#businessid").val();
    $.ajax({
        url: "./assets/api/reviews.php",
        type: 'POST',
        data: {mode: 'GET_reviews', business},
        success: function (data) {
            // Create an empty array to hold the transformed data
            var transformedData = [];

            // Iterate over each row in the data array
            for (var i = 0; i < data.length; i++) {
                var row = data[i];

                // Extract the values for each row and create a new object
                var transformedRow = {
                    'datetime': formatDatetime(row['datetime']),
                    'name': row['name'],
                    'phone': row['phone'],
                    'employee': row['employee'],
                    'rating': row['rating'],
                    'color': row['color'],
                    'questions': row['questions'],
                    'types': row['types'],
                    'answers': row['answers']
                };

                // Add the transformed row to the transformed data array
                transformedData.push(transformedRow);
            }

            // Populate the DataTable with the transformed data and enable export buttons
            var table = $('#datatable').DataTable({
                scrollX: true,
                data: transformedData,
                columns: [
                    { title: 'Datetime', data: 'datetime' },
                    { title: 'Name', data: 'name' },
                    { title: 'Phone', data: 'phone' },
                    { title: 'Employee', data: 'employee' },
                    { title: 'Rating', data: 'rating', render: function(data, type, row) {
                        let color = row['color'];
                        return '<span style="padding: 5px; border-radius: 5px; color: white; background-color:'+color+'">' + data + '</span>' }},
                    { title: 'Actions', defaultContent: '<button class="btn btn-primary action-btn">View</button>' }
                ],
                dom: 'Bfrtip', // Add export buttons to the DataTable
                buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
            });

            // Handle View click event
            $('#datatable').on('click', '.action-btn', function() {
                let data = table.row($(this).closest('tr')).data();
                let name = data['name'];
                let phone = data['phone'];
                let employee = data['employee'];
                let datetime = data['datetime'];
                let questions = data['questions'];
                questions = questions.split(";");
                let answers = data['answers'];
                answers = answers.split(";");
                let types = data['types'];
                types = types.split(";");
                let html=`<h1>${name}</h1>
                <a href="tel:+${phone}">${phone}</a>
                <p>Datetime: ${datetime}</p>
                <p>Employee: ${employee}</p>
                <table class='table'>
                    <thead>
                        <tr>
                            <th>Question</th>
                            <th>Answer</th>
                        </tr>
                    </thead>
                    <tbody>
                `;
                for(let i=0; i<questions.length; i++){
                    let color;
                    let answer = answers[i];
                    let question = questions[i];
                    let type = types[i];
                    if(type==3){
                        answer = parseFloat(answer).toFixed(1);
                        if(answer<=2.5)
                            color = '#ff0000';
                        if(answer>2.5 && answer<4.0)
                            color = '#ffd700';
                        if(answer>=4.0)
                            color = '#52bb56';
                        html +=`<tr>
                            <td>${question}</td>
                            <td><span style="padding: 5px; border-radius: 5px; color: white; background-color:${color}">${answer}</span></td>
                        </tr>`;
                    }
                    else{
                        if(type==5){
                            answer = answer.trim();
                            if(answer === "Yes")
                                color = '#52bb56';
                            if(answer === "No")
                                color = '#ff0000';
                            html +=`<tr>
                                <td>${question}</td>
                                <td><span style="padding: 5px; border-radius: 5px; color: white; background-color:${color}">${answer}</span></td>
                            </tr>`;
                        }
                        else {
                            html +=`<tr>
                                <td>${question}</td>
                                <td>${answer}</td>
                            </tr>`;
                        }
                    }
                }
                html += `</tbody></table>`;
                $('.modal-content').html(html);
                $('.modal-overlay').show();
                $('.modal-parent').show();
            });

            // Handle close button click event
            $('.modal').on('click', '.x', function() {
                $('.modal-overlay').hide();
                $('.modal-parent').hide();
            });
        }
    });
});

function formatDatetime(dateTimeStr) {
    // Parse the original datetime string
    const dateTime = new Date(dateTimeStr);
  
    // Get the date components
    const day = dateTime.getDate().toString().padStart(2, '0');
    const month = (dateTime.getMonth() + 1).toString().padStart(2, '0'); // Note: Months are 0-based
    const year = dateTime.getFullYear();
  
    // Get the time components
    let hours = dateTime.getHours();
    const minutes = dateTime.getMinutes().toString().padStart(2, '0');
    const ampm = hours >= 12 ? 'PM' : 'AM';
    hours = hours % 12 || 12; // Convert to 12-hour format
  
    // Create the formatted string
    const formattedDateTime = `${day}-${month}-${year} ${hours}:${minutes} ${ampm}`;
  
    return formattedDateTime;
  }