$(document).ready(function() {
    // Fetch questions from the server
    function fetchQuestions() {
        let business = $('#businessid').val();
        $.ajax({
            url: "./assets/api/questions.php",
            type: 'POST',
            data: {mode: 'GET_questions', business},
            success: function (questions) {
                // Clear existing questions
                $('#questions-container').empty();

                // Create draggable input lists based on the received data
                questions.forEach(function(question) {
                    var draggableItem = $(`<div class="draggable"><h4>${question.question}</h4></div>`);
                    draggableItem.data('questionid', question.id);
                    var draggableBtns = $(`<div class="d-flex align-items-center gap-3"></div>`);
                    var editBtn = $('<a class="edit-question-btn"><i class="fa fa-pencil fa-lg" aria-hidden="true"></i></a>');
                    editBtn.data('questionid', question.id);
                    editBtn.data('question', question.question);
                    editBtn.data('question_ar', question.question_ar);
                    editBtn.data('active', question.active);
                    editBtn.data('required', question.required);
                    editBtn.data('type', question.type);
                    if(question.type == 4){
                        for(var i=1; i<6; i++){
                            let name = 'an_en_'+i;
                            editBtn.data(name,question[name]);
                        }
                        for(var i=1; i<6; i++){
                            let name = 'an_ar_'+i;
                            editBtn.data(name,question[name]);
                        }
                    }
                    draggableBtns.append(editBtn);
                    if(question.active==1){
                        var deactivateBtn = $(`<a class="deactivate-question-btn"><i class="fa fa-toggle-on fa-lg" aria-hidden="true"></i></a>`)
                        deactivateBtn.data('questionid', question.id);
                        draggableBtns.append(deactivateBtn);
                    }
                    if(question.active==0){
                        var activateBtn = $(`<a class="activate-question-btn"><i class="fa fa-toggle-off fa-lg" aria-hidden="true"></i></a>`)
                        activateBtn.data('questionid', question.id);
                        draggableBtns.append(activateBtn);
                    }
                    var deleteBtn = $(`<a class="delete-question-btn"><i class="fa fa-trash fa-lg" aria-hidden="true"></i></a>`)
                    deleteBtn.data('questionid', question.id);
                    draggableBtns.append(deleteBtn);
                    draggableItem.append(draggableBtns);
                    $('#questions-container').append(draggableItem);
                });

                // Make the input lists draggable and update priority on drag
                $('.draggable').draggable({
                    cursor: 'move',
                    stop: function(event, ui) {
                        var questionid = $(this).data('questionid');
                        var newPosition = ui.position.top;

                        // Send the updated priority to the server
                        $.post('./assets/api/questions.php', { mode: 'UPDATE_priority', questionid, priority: newPosition });
                    }
                });
            }
        });
    }

    // Fetch and display the questions on page load
    fetchQuestions();

    // Handle add select input change event
    $('#add-question-type').on('change', function() {
        var answers = document.getElementById("add-multiple-answers");
        if($('#add-question-type').val()==4)
            answers.style.display = "flex";
        else    
            answers.style.display = "none";
    });

    // Add a new question
    $('#add-question-form').submit(function(event) {
        event.preventDefault();

        var business = $('#businessid').val();;
        var question = $('#add-question-text').val();
        var question_ar = $('#add-arabic-version').val();
        var active = 0;
        if($("#add-question-active").prop("checked") === true){ active = 1; }
        var required = 0;
        if($("#add-question-required").prop("checked") === true){ required = 1; }
        var type = $('#add-question-type').val();
        var answers = '';
        if(type == 4){
            answers = [];
            var answerInputs = document.getElementsByClassName("add-answer-en");
            for (var i = 0; i < answerInputs.length; i++) {
                var answerValue = answerInputs[i].value;
                answers.push(answerValue);
            }
            var answerInputs = document.getElementsByClassName("add-answer-ar");
            for (var i = 0; i < answerInputs.length; i++) {
                var answerValue = answerInputs[i].value;
                answers.push(answerValue);
            }
        }

        // Send the added question data to the server
        $.post('./assets/api/questions.php', {
            mode: 'ADD_question',
            business: business,
            question: question,
            question_ar: question_ar,
            type: type,
            active: active,
            required: required,
            answers: answers
        }, function(response) {
                location.reload();
        });
    });


    // Activate an existing question
    $(document).on('click', '.activate-question-btn', function() {
        var questionid = $(this).data('questionid');
        $.ajax({
            url: "./assets/api/questions.php",
            type: 'POST',
            data: {mode: 'ACTIVATE_question', questionid},
            success: function (response) {
                location.reload();
            }
        });
    });

    // Deactivate an existing question
    $(document).on('click', '.deactivate-question-btn', function() {
        var questionid = $(this).data('questionid');
        $.ajax({
            url: "./assets/api/questions.php",
            type: 'POST',
            data: {mode: 'DEACTIVATE_question', questionid},
            success: function (response) {
                location.reload();
            }
        });
    });

    // Delete an existing question
    $(document).on('click', '.delete-question-btn', function() {
        var questionid = $(this).data('questionid');
        $.ajax({
            url: "./assets/api/questions.php",
            type: 'POST',
            data: {mode: 'DELETE_question', questionid},
            success: function (response) {
                location.reload();
            }
        });
    });

    // Edit an existing question
    $(document).on('click', '.edit-question-btn', function() {
        var questionid = $(this).data('questionid');
        var question = $(this).data('question');
        var question_ar = $(this).data('question_ar');
        var type = $(this).data('type');
        var active = $(this).data('active');
        var required = $(this).data('required');
        var answers = document.getElementById("edit-multiple-answers");  
        answers.style.display = "none";
        if(type == 4){
            answers.style.display = "flex";
            for(var i=1; i<6; i++){
                let name = 'an_en_'+i;
                var value = $(this).data(name);
                let element = '#edit-answer-en-'+i;
                $(element).val(value);
            }
            for(var i=1; i<6; i++){
                let name = 'an_ar_'+i;
                var value = $(this).data(name);
                let element = '#edit-answer-ar-'+i;
                $(element).val(value);
            }
        }


        //Populate the edit form with question details
        $('#edit-question-id').val(questionid);
        $('#edit-question-text').val(question);
        $('#edit-arabic-version').val(question_ar);
        $('#edit-question-type').val(type);
        if(active == 1)
            $('#edit-question-active').prop("checked", true);
        else
            $('#edit-question-active').prop("checked", false);
        if(required == 1)
            $('#edit-question-required').prop("checked", true);
        else
            $('#edit-question-required').prop("checked", false);
        // Show the edit form
        $('.modal-overlay').show();
        $('.modal-parent').show();
    });

    // Handle edit select input change event
    $('.modal').on('change', '#edit-question-type', function() {
        var answers = document.getElementById("edit-multiple-answers");
        if($('#edit-question-type').val()==4)
            answers.style.display = "flex";
        else    
            answers.style.display = "none";
    });

    // Handle close button click event
    $('.modal').on('click', '.x', function() {
        $('.modal-overlay').hide();
        $('.modal-parent').hide();
    });

    // Update an existing question
    $('#edit-question-form').submit(function(event) {
        event.preventDefault();

        var questionid = $('#edit-question-id').val();;
        var question = $('#edit-question-text').val();
        var question_ar = $('#edit-arabic-version').val();
        var type = $('#edit-question-type').val();
        var active = 0;
        if($("#edit-question-active").prop("checked") === true){ active = 1; }
        var required = 0;
        if($("#edit-question-required").prop("checked") === true){ required = 1; }
        var answers = '';
        if(type == 4){
            answers = [];
            var answerInputs = document.getElementsByClassName("edit-answer-en");
            for (var i = 0; i < answerInputs.length; i++) {
                var answerValue = answerInputs[i].value;
                answers.push(answerValue);
            }
            var answerInputs = document.getElementsByClassName("edit-answer-ar");
            for (var i = 0; i < answerInputs.length; i++) {
                var answerValue = answerInputs[i].value;
                answers.push(answerValue);
            }
        }

        // Send the updated question data to the server
        $.post('./assets/api/questions.php', {
            mode: 'UPDATE_question',
            questionid: questionid,
            question: question,
            question_ar: question_ar,
            type: type,
            active: active,
            required: required,
            answers: answers
        }, function(response) {
                $('.modal-overlay').hide();
                $('.modal-parent').hide();
                fetchQuestions();
        });
    });

});