$(document).ready(function() {

    //Loading Bar Chart
    let business = $("#businessid").val();
    $.ajax({
        url: "./assets/api/charts.php",
        type: 'POST',
        data: {mode: 'REVIEWS', business},
        success: function (data) {
            let reviews = data;
            new Chart(document.getElementById("reviews-bars"), {
                type: "bar",
                data: {
                    labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                    datasets: [{
                        label: "Reviews",
                        backgroundColor: "#a90226",
                        borderColor: "#a90226",
                        hoverBackgroundColor: "#a90226",
                        hoverBorderColor: "#a90226",
                        data: reviews,
                    }]
                },
                options: {
                    maintainAspectRatio: false,
                    legend: {
                        display: false
                    },
                }
            });
        }
    });

    function loadRatingData() {
        $.ajax({
            type: "POST",
            url: "./assets/api/charts.php",
            data: {
                mode: 'RATING_QUESTIONS',
                business
            },
            success: function (data) {
                updateRatingTable(data);
            }
        });
    }

    function loadBooleanData() {
        $.ajax({
            type: "POST",
            url: "./assets/api/charts.php",
            data: {
                mode: 'BOOLEAN_QUESTIONS',
                business
            },
            success: function (data) {
                updateBooleanTable(data);
            }
        });
    }

    function loadGenderData() {
        $.ajax({
            type: "POST",
            url: "./assets/api/charts.php",
            data: {
                mode: 'GENDER',
                start_date: $('#start_date').val(),
                end_date: $('#end_date').val(),
                business
            },
            success: function (data) {
                updateGenderChart(data);
            }
        });
    }

    function loadAgeData() {
        $.ajax({
            type: "POST",
            url: "./assets/api/charts.php",
            data: {
                mode: 'AGE',
                start_date: $('#start_date').val(),
                end_date: $('#end_date').val(),
                business
            },
            success: function (data) {
                updateAgeChart(data);
            }
        });
    }

    function updateRatingTable(data) {
        let html = '<table class="table"><thead><tr><th>Question</th><th>Average</th></tr></thead><tbody>';
        for (let i = 0; i < data.length; i++) {
            let question = data[i].question;
            let average = parseFloat(data[i].average).toFixed(1);
            let color = '#ff0000';
            if (average > 2.5 && average < 4.0) {
                color = '#ffd700';
            } else if (average >= 4.0) {
                color = '#52bb56';
            }
            html += '<tr><td>' + question + '</td><td><span style="padding: 5px; border-radius: 5px; color: white; background-color:' + color + '">' + average + '</span></td></tr>';
        }
        html += '</tbody></table>';

        $('#rating_table').html(html);
    }

    function updateBooleanTable(data) {
        let html = '<table class="table"><thead><tr><th>Question</th><th>Yes</th><th>No</th></tr></thead><tbody>';
        for (let i = 0; i < data.length; i++) {
            let question = data[i].question;
            let yesPercentage = data[i].yes_percentage;
            let noPercentage = data[i].no_percentage;       
            html += '<tr><td>' + question + '</td><td><span style="padding: 5px; border-radius: 5px; color: white; background-color:#52bb56;">' + yesPercentage + ' %</span></td>' +
            '<td><span style="padding: 5px; border-radius: 5px; color: white; background-color:#ff0000;">' + noPercentage + ' %</span></td></tr>';
        }
        html += '</tbody></table>';

        $('#boolean_table').html(html);
    }

    function updateGenderChart(data) {
        let labels = ['Male', 'Female'];
        let backgroundColors = ['#0000FF', '#FFC0CB'];
    
        let chartData = [data.male_count, data.female_count];
        
        let canvas = document.getElementById('gender_pie');
        let ctx = canvas.getContext('2d');
        if (canvas.chartInstance) {
            canvas.chartInstance.destroy();
        }
        let chart = new Chart(ctx, {
            type: "pie",
            data: {
                labels: labels,
                datasets: [{
                    data: chartData,
                    backgroundColor: backgroundColors,
                }],
            },
            options: {
                maintainAspectRatio: false,
                legend: {
                    display: true,
                    position: 'bottom',
                }
            },
        });
        canvas.chartInstance = chart;
    }

    function updateAgeChart(data) {
        let ageCategories = {
            '0-18': 0,
            '18-30': 0,
            '30-50': 0,
            '50-above': 0
        };
    
        // Preprocess the data and categorize the ages
        for (let age in data) {
            let count = data[age];
            if (age >= 0 && age < 18) {
                ageCategories['0-18'] += count;
            } else if (age >= 18 && age < 30) {
                ageCategories['18-30'] += count;
            } else if (age >= 30 && age < 50) {
                ageCategories['30-50'] += count;
            } else  if (age >= 50){
                ageCategories['50-above'] += count;
            }
        }
    
        let labels = Object.keys(ageCategories);
        let values = Object.values(ageCategories);
        
        let canvas = document.getElementById('age_bars');
        let ctx = canvas.getContext('2d');
        if (canvas.chartInstance) {
            canvas.chartInstance.destroy();
        }
        let chart = new Chart(ctx, {
            type: "bar",
            data: {
                labels: labels,
                datasets: [{
                    label: "Customers",
                    backgroundColor: "#a90226",
                    borderColor: "#a90226",
                    hoverBackgroundColor: "#D4909F",
                    hoverBorderColor: "#D4909F",
                    data: values,
                }],
            },
            options: {
                maintainAspectRatio: false,
                legend: {
                    display: false,
                },
                scales: {
                    x: {
                        grid: {
                            display: false,
                        },
                    },
                    y: {
                        beginAtZero: true,
                        precision: 0,
                        scaleLabel: {
                            display: true,
                            labelString: 'Number of Customers'
                        }
                    },
                },
            },
        });
        canvas.chartInstance = chart;
    }

    loadRatingData();
    loadBooleanData();
    loadGenderData();
    loadAgeData();

    $('#apply_filter').click(function () {
        let startDate = $('#start_date').val();
        let endDate = $('#end_date').val();

        $.ajax({
            type: "POST",
            async: false,
            url: "./assets/api/charts.php",
            data: {
                mode: 'RATING_QUESTIONS',
                start_date: startDate,
                end_date: endDate,
                business
            },
            success: function (data) {
                updateRatingTable(data);
            }
        });

        $.ajax({
            type: "POST",
            async: false,
            url: "./assets/api/charts.php",
            data: {
                mode: 'BOOLEAN_QUESTIONS',
                start_date: startDate,
                end_date: endDate,
                business
            },
            success: function (data) {
                updateBooleanTable(data);
            }
        });

        $.ajax({
            type: "POST",
            async: false,
            url: "./assets/api/charts.php",
            data: {
                mode: 'GENDER',
                start_date: $('#start_date').val(),
                end_date: $('#end_date').val(),
                business
            },
            success: function (data) {
                updateGenderChart(data);
            }
        });

        $.ajax({
            type: "POST",
            async: false,
            url: "./assets/api/charts.php",
            data: {
                mode: 'AGE',
                start_date: $('#start_date').val(),
                end_date: $('#end_date').val(),
                business
            },
            success: function (data) {
                updateAgeChart(data);
            }
        });

    });

});