<?php 
    include("../../../../shared/common.php");
    $mode = $_POST['mode'];

    if ($mode == 'GET_reviews') {
        $business = $_POST['business'];
        $query = "SELECT 
                customer.firstname as firstname, 
                customer.lastname as lastname, 
                customer.phone as phone, 
                customer.ccode as ccode, 
                IFNULL(employee.name_en, '') as employee, 
                review.datetime as datetime, 
                GROUP_CONCAT(question.question ORDER BY question.priority SEPARATOR '; ') AS questions, 
                GROUP_CONCAT(question.type ORDER BY question.priority SEPARATOR '; ') AS types, 
                GROUP_CONCAT(review.answer ORDER BY question.priority SEPARATOR '; ') AS answers 
            FROM review
            INNER JOIN customer ON review.customer = customer.id
            INNER JOIN question ON review.question = question.id
            LEFT JOIN employee ON review.employee = employee.id
            WHERE review.business = $business 
            GROUP BY review.customer, customer.firstname, customer.lastname, customer.phone, customer.ccode, employee.name_en, review.datetime;";
        $result = $db->query($query);
        $count = $result->num_rows;
        $data = array();
        if ($count>0) {
            for($i=0;$i<$count;$i++){
                $row = $result->fetch_assoc();
                $name = $row['firstname'].' '.$row['lastname'];
                $data[$i]['name'] = $name;
                $ccode = $row['ccode'];
                $phone = ltrim($row['phone'], '0');
                $phone = $ccode.$phone;
                $data[$i]['phone'] = $phone;
                $data[$i]['employee'] = $row['employee'];
                $data[$i]['datetime'] = $row['datetime'];
                $data[$i]['questions'] = $row['questions'];
                $data[$i]['types'] = $row['types'];
                $data[$i]['answers'] = $row['answers'];
                $questions= explode(";", $row['questions']);
                $types= explode(";", $row['types']);
                $answers= explode(";", $row['answers']);
                $sum = 0;
                $len = 0;
                for($j=0;$j<count($questions);$j++){
                    if($types[$j] == 3){
                        $sum += $answers[$j];
                        $len += 1;
                    }
                }
                $rating = $sum / $len;
                $rating = number_format($rating, 1);
                $data[$i]['rating'] = $rating;
                if($rating<=2.5)
                    $data[$i]['color'] = '#ff0000';
                if($rating>2.5 && $rating<4)
                    $data[$i]['color'] = '#ffd700';
                if($rating>=4)
                    $data[$i]['color'] = '#52bb56';
            }
        }
        header('Content-type: application/json');
        echo json_encode($data);
    }
?>