<?php
    include("../../../../shared/common.php");
    $mode = $_POST['mode'];

    if ($mode == 'REVIEWS') {
        $business = $_POST['business'];
        $currentyear = (int)date("Y");
        $data = array();
        for($i=1;$i<13;$i++){
            $query = "SELECT customer FROM review WHERE YEAR(datetime)=$currentyear and MONTH(datetime)=$i and business=$business GROUP BY customer, datetime";
            $result = $db->query($query);
			$count = $db->numRows($result);
            $data[$i-1] = $count;
        }
        header('Content-type: application/json');
        echo json_encode($data);
    }

    if ($mode == 'RATING_QUESTIONS') {
        $business = $_POST['business'];
        $date_filter = "";
        if (isset($_POST['start_date']) && isset($_POST['end_date'])) {
            $start_date = $_POST['start_date'];
            $end_date = $_POST['end_date'];     
            if (!empty($start_date) && !empty($end_date)) {
                $start_datetime = $start_date . " 00:00:00";
                $end_datetime = $end_date . " 23:59:59";
                $date_filter = "AND review.datetime BETWEEN '$start_datetime' AND '$end_datetime'";
            } elseif (!empty($start_date) && empty($end_date)) {
                $start_datetime = $start_date . " 00:00:00";
                $date_filter = "AND review.datetime >= '$start_datetime'";
            } elseif (empty($start_date) && !empty($end_date)) {
                $end_datetime = $end_date . " 23:59:59";
                $date_filter = "AND review.datetime <= '$end_datetime'";
            }
        }
    
        $query = "SELECT question.question as question, GROUP_CONCAT(review.answer SEPARATOR '; ') AS answers 
        FROM review, question 
        WHERE review.question = question.id AND question.type = 3 AND review.business = $business AND question.active = 1 $date_filter
        GROUP BY review.question";
        $result = $db->query($query);

        $filtered_data = array();

        while ($row = $result->fetch_assoc()) {
            $answersArray = explode('; ', $row['answers']);
    
            $sum = 0;
            foreach ($answersArray as $answer) {
                $sum += (float)$answer;
            }
    
            $average = count($answersArray) > 0 ? $sum / count($answersArray) : 0;
    
            $filtered_data[] = array(
                'question' => $row['question'],
                'average' => $average
            );
        }

        header('Content-Type: application/json');
        echo json_encode($filtered_data);
    }

    if ($mode == 'BOOLEAN_QUESTIONS') {
        $business = $_POST['business'];
        $date_filter = "";
        if (isset($_POST['start_date']) && isset($_POST['end_date'])) {
            $start_date = $_POST['start_date'];
            $end_date = $_POST['end_date'];     
            if (!empty($start_date) && !empty($end_date)) {
                $start_datetime = $start_date . " 00:00:00";
                $end_datetime = $end_date . " 23:59:59";
                $date_filter = "AND review.datetime BETWEEN '$start_datetime' AND '$end_datetime'";
            } elseif (!empty($start_date) && empty($end_date)) {
                $start_datetime = $start_date . " 00:00:00";
                $date_filter = "AND review.datetime >= '$start_datetime'";
            } elseif (empty($start_date) && !empty($end_date)) {
                $end_datetime = $end_date . " 23:59:59";
                $date_filter = "AND review.datetime <= '$end_datetime'";
            }
        }
    
        $query = "SELECT question.question as question, GROUP_CONCAT(review.answer SEPARATOR '; ') AS answers 
        FROM review, question 
        WHERE review.question = question.id AND question.type = 5 AND review.business = $business AND question.active = 1 $date_filter
        GROUP BY review.question";
        $result = $db->query($query);

        $filtered_data = array();

        while ($row = $result->fetch_assoc()) {
            $answersArray = explode('; ', $row['answers']);
            $yesCount = 0;
            $noCount = 0;
            
            foreach ($answersArray as $answer) {
                if ($answer === 'Yes') {
                    $yesCount++;
                } elseif ($answer === 'No') {
                    $noCount++;
                }
            }
            
            $totalAnswers = $yesCount + $noCount;
            
            $yesPercentage = ($totalAnswers > 0) ? ($yesCount / $totalAnswers) * 100 : 0;
            $noPercentage = ($totalAnswers > 0) ? ($noCount / $totalAnswers) * 100 : 0;
            
            $filtered_data[] = array(
                'question' => $row['question'],
                'yes_percentage' => round($yesPercentage, 2),
                'no_percentage' => round($noPercentage, 2)
            );
        }

        header('Content-Type: application/json');
        echo json_encode($filtered_data);
    }

    if ($mode == 'GENDER') { 
        $business = $_POST['business'];
        $date_filter = "";
        if (isset($_POST['start_date']) && isset($_POST['end_date'])) {
            $start_date = $_POST['start_date'];
            $end_date = $_POST['end_date'];     
            if (!empty($start_date) && !empty($end_date)) {
                $start_datetime = $start_date . " 00:00:00";
                $end_datetime = $end_date . " 23:59:59";
                $date_filter = "AND review.datetime BETWEEN '$start_datetime' AND '$end_datetime'";
            } elseif (!empty($start_date) && empty($end_date)) {
                $start_datetime = $start_date . " 00:00:00";
                $date_filter = "AND review.datetime >= '$start_datetime'";
            } elseif (empty($start_date) && !empty($end_date)) {
                $end_datetime = $end_date . " 23:59:59";
                $date_filter = "AND review.datetime <= '$end_datetime'";
            }
        } 
        $query = "SELECT 
            COUNT(DISTINCT CASE WHEN c.gender = 'Male' THEN c.id END) AS male_count,
            COUNT(DISTINCT CASE WHEN c.gender = 'Female' THEN c.id END) AS female_count
        FROM (
            SELECT DISTINCT c.id, c.gender
            FROM review
            INNER JOIN customer c ON review.customer = c.id
            WHERE review.business = $business $date_filter
        ) AS c;";
    
        $result = $db->query($query);
        $data = $result->fetch_assoc();
    
        header('Content-type: application/json');
        echo json_encode($data);
    }

    if ($mode == 'AGE') {
        $business = $_POST['business'];
        $date_filter = "";
        if (isset($_POST['start_date']) && isset($_POST['end_date'])) {
            $start_date = $_POST['start_date'];
            $end_date = $_POST['end_date'];     
            if (!empty($start_date) && !empty($end_date)) {
                $start_datetime = $start_date . " 00:00:00";
                $end_datetime = $end_date . " 23:59:59";
                $date_filter = "AND review.datetime BETWEEN '$start_datetime' AND '$end_datetime'";
            } elseif (!empty($start_date) && empty($end_date)) {
                $start_datetime = $start_date . " 00:00:00";
                $date_filter = "AND review.datetime >= '$start_datetime'";
            } elseif (empty($start_date) && !empty($end_date)) {
                $end_datetime = $end_date . " 23:59:59";
                $date_filter = "AND review.datetime <= '$end_datetime'";
            }
        } 
        $query = "SELECT IFNULL(FLOOR(DATEDIFF(NOW(), customer.birthday) / 365), -1) AS age,
                         COUNT(DISTINCT review.customer) AS count
                  FROM review
                  INNER JOIN customer ON review.customer = customer.id
                  WHERE review.business = $business $date_filter
                  GROUP BY age";
    
        $result = $db->query($query);
    
        $data = array();
        while ($row = $result->fetch_assoc()) {
            $data[$row['age']] = $row['count'];
        }
    
        header('Content-type: application/json');
        echo json_encode($data);
    }  
?>