<?php

    include("../../shared/common.php");

    if(!isset($_SESSION['id']) || $_SESSION['role']!=='admin'){
        echo "<script type='text/javascript'>
            window.location = '../index';
        </script>";
    }
    
    $active = 'roles';
    $current_admin = $_SESSION['id'];

?>

<html>
    <head>
        <link rel="shortcut icon" href="../../shared/logos/wereview_icon.png">
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width,initial-scale=1">
        <meta name="description" content="WeReview System" />
        <link rel="preconnect" href="https://fonts.gstatic.com" />
        <title>WeReview System</title>
        <link href="../../shared/css/app.css" rel="stylesheet" />
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>
        <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css" />
        <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
    </head>
    
    <body>
        <div class="wrapper">
            <?php 
                include('includes/sidebar.php');
            ?>
            <div class="main">
            <?php 
                include('includes/header.php');
            ?>
            <main class="content">
                <div class="container-fluid p-0">
                    <div class="d-flex mb-4 justify-content-between align-items-center">
                        <h3><strong>Roles</strong></h3>
                        <button class="btn btn-primary w-auto" onclick="javascript: window.location.href = 'create-role';">Create Role</button>
                    </div>
                    <div class="card w-100">
                        <div class="card-body px-4 w-100">
                            <table id="data" class="display nowrap" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>English Name</th>
                                        <th>Arabic Name</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $sql="select * from role";
                                        $result = $db->query($sql);
                                        if($result){
                                            while($row = mysqli_fetch_array($result)){
                                    ?>
                                    <tr>
                                        <td><?php echo $row['id'];?></td>
                                        <td><?php echo $row['name_en'];?></td>
                                        <td><?php echo $row['name_ar'];?></td>
                                        <td>
                                            <div class="d-flex align-items-center gap-3">
                                                <a href="edit-role?id=<?php echo $row['id'];?>"><i class="fa fa-pencil fa-lg" aria-hidden="true"></i></a>
                                                <a href="delete-role?id=<?php echo $row['id'];?>"><i class="fa fa-trash fa-lg" aria-hidden="true"></i></a>       
                                            </div>
                                        </td>
                                    </tr>
                                    <?php 
                                            }
                                        }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </main>
            <?php 
                include('includes/footer.php');
            ?> 
        </div>
        
        <script src="../../shared/js/app.js"></script>
        <script>
            $(document).ready(function() {
                $('#data').DataTable({scrollX:true});
            });
        </script>
        
    </body>
</html>