<?php

    include("../../shared/common.php");

    if(!isset($_SESSION['id']) || ($_SESSION['role']!=='admin' && $_SESSION['role']!=='agent')){
        echo "<script type='text/javascript'>
            window.location = '../index';
        </script>";
    }
    
    $active = 'businesses';
    $current_admin = $_SESSION['id'];

?>

<html>
    <head>
        <link rel="shortcut icon" href="../../shared/logos/wereview_icon.png">
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width,initial-scale=1">
        <meta name="description" content="WeReview System" />
        <link rel="preconnect" href="https://fonts.gstatic.com" />
        <title>WeReview System</title>
        <link href="../../shared/css/app.css" rel="stylesheet" />
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    </head>
    
    <body>
        <div class="wrapper">
            <?php 
                include('includes/sidebar.php');
            ?>
            <div class="main">
            <?php 
                include('includes/header.php');
            ?>
            <main class="content">
                <div class="container-fluid p-0">
                    <h3 class="mb-4"><strong>Create Business</strong></h3>

                    <form class="w-100 d-flex flex-column gap-4 justify-content-center" enctype="multipart/form-data">

						<div class="row justify-items-between gap-4 gap-md-0">
                            <div class="col-md-4">
						        <label id="lblname" class="mb-2">Name*</label>
						        <input type="text" class="form-control" name="name" id="name" required>
                                <span id="feedbackname" class="invalid-feedback"></span>
					    	</div>
					    	<div class="col-md-4">
						        <label id="lblemail" class="mb-2">Email*</label>
						        <input type="text" class="form-control" name="email" id="email" required>
                                <span id="feedbackemail" class="invalid-feedback"></span>
					    	</div>
                            <div class="col-md-4">
						        <label id="lblmobile" class="mb-2">Mobile*</label>
						        <input type="text" class="form-control" name="mobile" id="mobile" required>
                                <span id="feedbackmobile" class="invalid-feedback"></span>
					    	</div>
						</div>

                        <div class="row justify-items-between gap-4 gap-md-0">
                            <div class="col-md-4">
						        <label id="lblphone" class="mb-2">Phone</label>
						        <input type="text" class="form-control" name="phone" id="phone">
					    	</div>
					    	<div class="col-md-4">
						        <label id="lbladdress" class="mb-2">Address</label>
						        <input type="text" class="form-control" name="address" id="address">
					    	</div>
                            <div class="col-md-4">
						        <label id="lblcountry" class="mb-2">Country*</label>
						        <select class="form-select" name="country" id="country" required>
                                    <?php
                                        $sql ="SELECT id, name FROM country";
                                        $result = $db->query($sql);
                                        if($result){
                                            $nbline = mysqli_num_rows($result);
                                            for($i=0;$i<$nbline;$i++) {
                                                $line=mysqli_fetch_row($result);
                                                echo"<option value=".$line[0].">".$line[1]."</option>";
                                            }
                                        }
                                    ?>
                                </select>
					    	</div>
						</div>

                        <div class="row justify-items-between gap-4 gap-md-0">
                            <div class="col-md-4">
						        <label id="lblcountry" class="mb-2">City*</label>
						        <select class="form-select" name="city" id="city" required>
                                    <?php
                                        $sql ="SELECT city.id as id, city.name as name FROM city, country where city.country=country.id and country.name='Lebanon'";
                                        $result = $db->query($sql);
                                        if($result){
                                            $nbline = mysqli_num_rows($result);
                                            for($i=0;$i<$nbline;$i++) {
                                                $line=mysqli_fetch_row($result);
                                                echo"<option value=".$line[0].">".$line[1]."</option>";
                                            }
                                        }
                                    ?>
                                </select>
					    	</div>
                            <div class="col-md-4">
						        <label id="lblcolor" class="mb-2">Primary Color (#FFFFFF)</label>
						        <input type="color" class="form-control" name="color" id="color">
					    	</div>
                            <div class="col-md-4">
						        <label id="lblcdate" class="mb-2">Creation Date*</label>
						        <input type="date" class="form-control" name="cdate" id="cdate" required>
								<span id="feedbackcdate" class="invalid-feedback"></span>
					    	</div>
						</div>
						
                        <div class="row justify-items-between gap-4 gap-md-0">
                            <div class="col-md-4">
						        <label id="lblinstagram" class="mb-2">Instagram</label>
						        <input type="text" class="form-control" name="instagram" id="instagram">
					    	</div>
                            <div class="col-md-4">
						        <label id="lbltiktok" class="mb-2">Tiktok</label>
						        <input type="text" class="form-control" name="tiktok" id="tiktok">
					    	</div>
                            <div class="col-md-4">
						        <label id="lblfacebook" class="mb-2">Facebook</label>
						        <input type="text" class="form-control" name="facebook" id="facebook">
					    	</div>
						</div>

                        <div class="row justify-items-between gap-4 gap-md-0">
                            <div class="col-md-4">
						        <label id="lbltwitter" class="mb-2">Twitter</label>
						        <input type="text" class="form-control" name="twitter" id="twitter">
					    	</div>
                            <div class="col-md-4">
						        <label id="lblsnapchat" class="mb-2">Snapchat</label>
						        <input type="text" class="form-control" name="snapchat" id="snapchat">
					    	</div>
                            <div class="col-md-4">
						        <label id="lblyoutube" class="mb-2">Youtube</label>
						        <input type="text" class="form-control" name="youtube" id="youtube">
					    	</div>
						</div>

                        <div class="row justify-items-between gap-4 gap-md-0">
                            <div class="col-md-4">
						        <label id="lbllinkedin" class="mb-2">Linkedin</label>
						        <input type="text" class="form-control" name="linkedin" id="linkedin">
					    	</div>
							<div class="col-md-4">
						        <label id="lblrole" class="mb-2">Role*</label>
						        <select class="form-select" name="role" id="role" required>
                                    <?php
                                        $sql ="SELECT id, name_en FROM role";
                                        $result = $db->query($sql);
                                        if($result){
                                            $nbline = mysqli_num_rows($result);
                                            for($i=0;$i<$nbline;$i++) {
                                                $line=mysqli_fetch_row($result);
                                                echo"<option value=".$line[0].">".$line[1]."</option>";
                                            }
                                        }
                                    ?>
                                </select>
					    	</div>
							<div class="col-md-4">
						        <label id="lblfollowus" class="mb-2">Follow Us Text</label>
						        <input type="text" class="form-control" name="followus" id="followus">
					    	</div>
						</div>

                        <div class="row justify-items-between gap-4 gap-md-0">
                            <div class="col-md-4 d-flex align-items-end">
                                <div class="d-flex gap-2">
                                    <input type="checkbox" id="active" class="form-check-input"> 
                                    <span>Active</span> 
                                </div>
                            </div>
                        </div>

                        <div class="d-flex flex-column justify-content-center gap-2">
						    <label>Upload Logo (180x180px)</label>
    						<div class="row justify-items-between align-items-center">
    						    <div class="w-50">
        				    	    <input type="file" id="logo" class="form-control" name="logo" accept=".png, .jpg, .jpeg">
    				        	</div>
    					    	<div class="w-50">
    						        <button type="button" id="btnLogo" class="btn btn-primary text-center">Upload</button>
    					    	</div>
    						</div>
						</div>
						<div id="displayLogo"></div>

                        <div class="d-flex flex-column justify-content-center gap-2">
						    <label>Upload Background (800x1280px)</label>
    						<div class="row justify-items-between align-items-center">
    						    <div class="w-50">
        				    	    <input type="file" id="background" class="form-control" name="background" accept=".png, .jpg, .jpeg">
    				        	</div>
    					    	<div class="w-50">
    						        <button type="button" id="btnBackground" class="btn btn-primary text-center">Upload</button>
    					    	</div>
    						</div>
						</div>
						<div id="displayBackground"></div>

                        <div class="d-flex flex-column justify-content-center gap-2">
						    <label>Menu Link</label>
    						<div class="row justify-items-between align-items-center">
    						    <div class="w-50">
        				    	    <input class="form-control" id="menu_link" name="menu_link">
    				        	</div>
    						</div>
						</div>

                        <div class="d-flex flex-column justify-content-center gap-2">
						    <label>Upload Menu (PDF)</label>
    						<div class="row justify-items-between align-items-center">
    						    <div class="w-50">
        				    	    <input type="file" class="form-control" id="menu" name="menu" accept=".pdf">
    				        	</div>
    					    	<div class="w-50">
    						        <button type="button" id="btnMenu" class="btn btn-primary text-center">Upload</button>
    					    	</div>
    						</div>
						</div>
						<div id="displayMenu"></div>
						
						<div class="d-flex gap-3">
							<button type="button" id="create" name="create" class="btn btn-lg btn-primary text-center">Create</button>
							<button type="button" id="cancel" name="cancel" class="btn btn-lg btn-secondary text-center">Cancel</button>
						</div> 
					</form> 
                </div>
            </main>
            <?php 
                include('includes/footer.php');
            ?> 
        </div>
        
        <script src="../../shared/js/app.js"></script>
        <script src="assets/js/create-business.js"></script>
        
    </body>
</html>