$(document).ready(function() {
    const color = document.querySelector("#color").value;
    const business = document.querySelector("#business").value;
    const customer = document.querySelector("#customer").value;
    let button = document.querySelector("#profile");

    button.addEventListener('click', () => {
        $.ajax({
            url: "./assets/api/customer.php",
            type: 'POST',
            async: false,
            data: {request:'loadCustomer', customer},
            success: function (infos) {
                let language = infos[0].lang;
                // Gender checked
                let checkF = (infos[0].gender == 'Female')?'checked':'';
                let checkM = (infos[0].gender == 'Male')?'checked':'';
                // Fetch Cities
                let citiesRequest = fetch("./assets/api/cities.php", {
                    method: "POST",
                    headers: { "Content-Type": "application/json" },
                    body: JSON.stringify({ business:business }),
                })
                .then(response => response.json())
                .then(data => {
                    let cities = [];
                    for (var i = 0; i < data.length; i++) {
                        cities.push({ id:data[i].id, name:data[i].name })
                    }
                    return cities;
                });
                Promise.all([citiesRequest]).then(([cities]) => {
                    let cityOptions_en = "<option hidden disabled selected value>Choose city</option>";
                    let cityOptions_ar = "<option hidden disabled selected value>اختر مدينتك</option>";
                    cities.forEach(function(city) {
                        selected = "";
                        if(city.id == infos[0].city)
                            selected = "selected";
                        cityOptions_en += '<option ' + selected +' value="' + city.id + '">' + city.name + '</option>';
                        cityOptions_ar += '<option ' + selected +' value="' + city.id + '">' + city.name + '</option>';
                    });
                    Swal.fire({
                        title: 'Profile',
                        html: `
                            <div class="switch-container">
                                <button id="english-btn" class="switch-button ${language === 'en' ? 'active' : ''}">English</button>
                                <button id="arabic-btn" class="switch-button ${language === 'ar' ? 'active' : ''}">العربية</button>
                            </div>
                            <div id="swal2-form">
                                <div style="margin: 1em 2em 0;">
                                    <label for="female" class="swal2-radio">
                                        <input type="radio" id="female" name="gender" value="Female" ${checkF}>
                                        <span class="swal2-label">Female</span>
                                    </label>
                                    <label for="male" class="swal2-radio">
                                        <input type="radio" id="male" name="gender" value="Male" ${checkM}>
                                        <span class="swal2-label">Male</span>
                                    </label>
                                </div>
                                <input id="firstname" class="swal2-input" placeholder="First Name*" value="${infos[0].firstname}">
                                <input id="lastname" class="swal2-input" placeholder="Last Name*" value="${infos[0].lastname}">
                                <input id="ccode" class="swal2-input" hidden value="${infos[0].ccode}">
                                <input id="phone" class="swal2-input" readonly value="${infos[0].phone}">
                                <input id="email" class="swal2-input" placeholder="Email" value="${infos[0].email}">
                                <div>
                                    <p id="birthday-label" style="text-align: left; margin-bottom: -5px; color: #545454;">Birthday</p>
                                    <input id="birthday" type="date" class="swal2-input" placeholder="Birthday" value="${infos[0].birthday}">
                                </div>
                                <select id="city" class="swal2-select">
                                    ${cityOptions_en}
                                </select>
                            </div>
                        `,
                        showCancelButton: true,
                        showConfirmButton: true,
                        confirmButtonText: 'Submit',
                        customClass: {
                            container: 'scrollable-swal',
                        },
                        preConfirm: () => {
                            // Handle form submission
                            let language = '';
                            if ($('#english-btn').hasClass('active')) 
                                language = 'en';
                            else
                                language = 'ar';
                            const firstname = document.querySelector('#firstname').value;
                            const lastname = document.querySelector('#lastname').value;
                            const city = document.querySelector('#city').value;
                            const ccode = document.querySelector('#ccode').value;
                            const phone = document.querySelector('#phone').value;
                            const gender = document.querySelector('input[name="gender"]:checked')?.value;
                            const birthday = document.querySelector('#birthday').value;
                            const email = document.querySelector('#email').value;
                            if (!firstname || !lastname || !phone) {
                                Swal.showValidationMessage('Please fill in all required fields');
                            } else {
                                return [firstname, lastname, city, ccode, phone, gender, birthday, email, language];
                            }
                        },
                        didOpen: () => {
                            const popup = Swal.getPopup();
                            popup.scrollTop = 0;
                            const cancelButton = Swal.getCancelButton();
                            const confirmButton = Swal.getConfirmButton();
                            if (confirmButton) {
                                confirmButton.style.backgroundColor = color;
                            }
                            
                            $("#english-btn").click((e) => {
                                e.preventDefault();
                                $("#arabic-btn").removeClass("active");
                                $("#english-btn").addClass("active");

                                const firstname = document.querySelector('#firstname');
                                const femaleRadioLabel = document.querySelector('.swal2-radio[for="female"]');
                                const maleRadioLabel = document.querySelector('.swal2-radio[for="male"]');
                                const lastname = document.querySelector('#lastname');
                                const city = document.querySelector('#city');
                                const birthday = document.querySelector('#birthday-label');
                                const email = document.querySelector('#email');

                                $('#swal2-form').css('direction', 'ltr');
                                firstname.placeholder = 'First Name*';
                                lastname.placeholder = 'Last Name*';
                                femaleRadioLabel.innerHTML = `
                                    <input type="radio" id="female" name="gender" value="Female" ${checkF}>
                                    <span class="swal2-label">Female</span>
                                `;
                                maleRadioLabel.innerHTML = `
                                    <input type="radio" id="male" name="gender" value="Male" ${checkM}>
                                    <span class="swal2-label">Male</span>
                                `;
                                city.innerHTML = cityOptions_en;
                                birthday.textContent = 'Birthday';
                                birthday.style.cssText = "text-align: left; margin-bottom: -5px; color: #545454;";
                                email.placeholder = 'Email';
                            });

                            $("#arabic-btn").click((e) => {
                                e.preventDefault();
                                $("#english-btn").removeClass("active");
                                $("#arabic-btn").addClass("active");

                                const firstname = document.querySelector('#firstname');
                                const femaleRadioLabel = document.querySelector('.swal2-radio[for="female"]');
                                const maleRadioLabel = document.querySelector('.swal2-radio[for="male"]');
                                const lastname = document.querySelector('#lastname');
                                const city = document.querySelector('#city');
                                const birthday = document.querySelector('#birthday-label');
                                const email = document.querySelector('#email');

                                $('#swal2-form').css('direction', 'rtl');
                                firstname.placeholder = '*الاسم الأول';
                                lastname.placeholder = '*اسم العائلة';
                                femaleRadioLabel.innerHTML = `
                                    <input type="radio" id="female" name="gender" value="Female" ${checkF}>
                                    <span class="swal2-label">أنثى</span>
                                `;
                                maleRadioLabel.innerHTML = `
                                    <input type="radio" id="male" name="gender" value="Male" ${checkM}>
                                    <span class="swal2-label">ذكر</span>
                                `;
                                city.innerHTML = cityOptions_ar;
                                birthday.textContent = 'تاريخ الميلاد';
                                birthday.style.cssText = "text-align: right; margin-bottom: -5px; color: #545454;";
                                email.placeholder = 'البريد الإلكتروني';
                            });

                            if(language == 'ar')
                                $("#arabic-btn").trigger('click');
                        }
                    }) .then((result) => {
                        if (result.value) {
                            $.ajax({
                                url: "./assets/api/customer.php",
                                type: 'POST',
                                async: false,
                                data: { request:'updateCustomer', data: result.value, customer },
                                success: function (data) {
                                    if(data=="Done")
                                        Swal.close();
                                }
                            });
                        }
                    });
                });
            }
        });
    });
});