$(document).ready(function() {

    const business = $("#business").val();
    const customer = $("#customer").val();
    const language = $("#language").val();
    if(language=="ar"){
        $("#questions").attr("dir", "rtl");
    }

    $.ajax({
        url: "./assets/api/review.php",
        type: 'POST',
        async: false,
        data: { request: "getQuestions", business },
        success: function (data) {
            let html = ``;
            let i = 0;
            data.forEach((question) => {
                let text = '';
                let required = '';
                language == 'en' ? text = question.question : text = question.question_ar;
                question.required == 1 ? text += ' *' : text += '';
                question.required == 1 ? required = 'required' : required = '';
                switch (question.type) {
                    case '1':
                        html += `<div><h4>${text}</h4><input type="text" class="input ${required}" name="${question.id}"></input></div>`;
                        break;
                    case '2':
                        html += `<div><h4>${text}</h4><textarea class="area ${required}" name="${question.id}" rows="3"></textarea></div>`;
                        break;
                    case '3':
                        html += `<div>
                            <h4>${text}</h4>
                            <div class="rating">
                                <input type="radio" id="q${i}-star5" name="${question.id}" class="${required}" value="5">
                                <label for="q${i}-star5" onclick="handleRating(this)"><i class="fas fa-star fa-lg"></i></label>
                                <input type="radio" id="q${i}-star4" name="${question.id}" class="${required}" value="4">
                                <label for="q${i}-star4" onclick="handleRating(this)"><i class="fas fa-star fa-lg"></i></label>
                                <input type="radio" id="q${i}-star3" name="${question.id}" class="${required}" value="3">
                                <label for="q${i}-star3" onclick="handleRating(this)"><i class="fas fa-star fa-lg"></i></label>
                                <input type="radio" id="q${i}-star2" name="${question.id}" class="${required}" value="2">
                                <label for="q${i}-star2" onclick="handleRating(this)"><i class="fas fa-star fa-lg"></i></label>
                                <input type="radio" id="q${i}-star1" name="${question.id}" class="${required}" value="1">
                                <label for="q${i}-star1" onclick="handleRating(this)"><i class="fas fa-star fa-lg"></i></label>
                            </div>
                        </div>`;
                        break;
                    case '5':
                        html += `<div>
                            <h4>${text}</h4>
                            <div class="radio-buttons">
                                <input type="radio" id="q${i}-yes" name="${question.id}" class="${required}" value="Yes">
                                <label for="q${i}-yes">${language == "en" ? 'Yes':'نعم'}</label>
                                <input type="radio" id="q${i}-no" class="${required}" name="${question.id}" value="No">
                                <label for="q${i}-no">${language == "en" ? 'No':'لا'}</label>
                            </div>
                        </div>`;
                        break;
                    case '4':
                        $.ajax({
                            url: "./assets/api/choices.php",
                            type: 'POST',
                            async: false,
                            data: { question: question.id, language },
                            success: function (choices) {
                                html += `<div>
                                <h4>${text}</h4>
                                <div class="checkboxes">`;
                                for(let j=0; j<choices.length; j++){
                                    const an = choices[j];
                                    if(an){
                                        html += `<div style="margin-top: 5px;"><input type="checkbox" id="q${i}-option${j}" name="${question.id}" class="${required}" value="${an}">
                                        <label for="q${i}-option${j}">${an}</label></div>`;
                                    }
                                }
                                html += `</div>
                            </div>`;
                            }
                        });
                        break;
                    default:
                        console.log('Error');
                        break;
                }
                i++;
            });
            $("#questions").append(html);
        }
    });

    $("#submit").click(function ()  {
        let valid = true;
        let answersArray = [];

        $("input.required, textarea.required").each(function() {
            if ($(this).val().trim() === "") {
                valid = false;
            }
        });

        $("input[type='radio'].required, input[type='checkbox'].required").each(function() {
            const groupName = $(this).attr("name");
            if ($(`input[name='${groupName}']:checked`).length === 0) {
                valid = false;
            }
        });

        $("select.required").each(function() {
            if ($(this).val() === "" || $(this).val() === null) {
                valid = false;
            }
        });

        if (valid) {
            $("#error").text('');

            $("input[type='text']:visible, textarea:visible").each(function () {
                const questionId = $(this).attr("name");
                const answer = $(this).val().trim();
                if(answer)
                    answersArray.push({ questionId, answer });
            });
    
            $("input[type='radio']:checked, input[type='checkbox']:checked").each(function () {
                const questionId = $(this).attr("name");
                const answer = $(this).val();
                if(answer)
                    answersArray.push({ questionId, answer });
            });
            
            answersArray = mergeObjectsWithSameQuestionId(answersArray);

            employee = $("#employee").val();

            $.ajax({
                url: "./assets/api/review.php",
                type: 'POST',
                data: { request: "submitReview", business, employee: employee || null, customer, reviews: answersArray },
                success: function (response) {
                    window.location = 'thankyou?business=' + business;
                }
            });

          
        } else {
            $("#error").text('Please Fill All Required Fields!');
        }
    });

});

function handleRating(label) {
    const allLabels = label.parentElement.querySelectorAll('label');
    
    allLabels.forEach((label) => {
      const input = label.previousElementSibling;
      if (label === label) {
        input.checked = true;
        label.classList.add('checked');
      } else {
        input.checked = false;
        label.classList.remove('checked');
      }
    });
}

function mergeObjectsWithSameQuestionId(arr) {
    const mergedObjects = [];
    const groupedByQuestionId = {};

    // Group objects by questionId
    arr.forEach((obj) => {
        const { questionId, answer } = obj;
        if (!groupedByQuestionId[questionId]) {
            groupedByQuestionId[questionId] = [answer];
        } else {
            groupedByQuestionId[questionId].push(answer);
        }
    });

    // Create merged objects with comma-separated answers
    for (const questionId in groupedByQuestionId) {
        const answerString = groupedByQuestionId[questionId].join(', ');
        mergedObjects.push({ questionId, answer: answerString });
    }

    return mergedObjects;
}