$(document).ready(function() {
    const color = document.querySelector("#color").value;
    const business = document.querySelector("#business").value;
    let input = document.querySelector("#phone");
    const errorMsg = document.querySelector("#error-msg");
    const validMsg = document.querySelector("#valid-msg");
    let button = document.querySelector("#next");
    const errorMap = ["Invalid number", "Invalid country code", "Too short", "Too long", "Invalid number"];
    const iti = window.intlTelInput(input, {
        preferredCountries: ['lb', 'qa', 'sa', 'ae'],
        excludeCountries: ["il"],
        initialCountry: "lb",
        utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@18.1.1/build/js/utils.js",
    });
    const validate = () => {
        button.classList.add("disabled");
        errorMsg.innerHTML = "";
        errorMsg.classList.add("hide");
        validMsg.innerHTML = "";
        validMsg.classList.add("hide");
        if (input.value.trim()) {
            if (iti.isValidNumber()) {
                validMsg.classList.remove("hide");
                validMsg.innerHTML = "✓ Valid";
                button.classList.remove("disabled");
            } else {
                const errorCode = iti.getValidationError();
                errorMsg.innerHTML = errorMap[errorCode];
                errorMsg.classList.remove("hide");
            }
        }
    };
    input.addEventListener('change', validate);
    input.addEventListener('keyup', validate);

    button.addEventListener('click', () => {
        if(!validMsg.classList.contains("hide")){
            const selectedCountryData = iti.getSelectedCountryData();
            const countryCode = selectedCountryData.dialCode;
            const fullPhoneNumber = iti.getNumber();
            const phoneRegex = new RegExp('^\\+?' + countryCode);
            const phoneNumber = fullPhoneNumber.replace(phoneRegex, '');
            $.ajax({
                url: "./assets/api/auth.php",
                type: 'POST',
                async: false,
                data: {countryCode, phoneNumber, business},
                success: function (response) {
                    if(response.status == 'EXIST') {
                        window.location = 'welcome?business='+business+'&customer='+response.customer_id+'&our='+response.our;
                    } else {
                        // Fetch Cities
                        let citiesRequest = fetch("./assets/api/cities.php", {
                            method: "POST",
                            headers: { "Content-Type": "application/json" },
                            body: JSON.stringify({ business:business }),
                        })
                        .then(response => response.json())
                        .then(data => {
                            let cities = [];
                            for (var i = 0; i < data.length; i++) {
                                cities.push({ id:data[i].id, name:data[i].name })
                            }
                            return cities;
                        });
                        Promise.all([citiesRequest]).then(([cities]) => {
                            let cityOptions_en = "<option hidden disabled selected value>Choose city</option>";
                            let cityOptions_ar = "<option hidden disabled selected value>اختر مدينتك</option>";
                            cities.forEach(function(city) {
                                cityOptions_en += '<option value="' + city.id + '">' + city.name + '</option>';
                                cityOptions_ar += '<option value="' + city.id + '">' + city.name + '</option>';
                            });
                            Swal.fire({
                                title: 'Registration Form',
                                html: `
                                    <div class="switch-container">
                                        <button id="english-btn" class="switch-button active">English</button>
                                        <button id="arabic-btn" class="switch-button">العربية</button>
                                    </div>
                                    <div id="swal2-form">
                                        <div style="margin: 1em 2em 0;">
                                            <label for="female" class="swal2-radio">
                                                <input type="radio" id="female" name="gender" value="Female">
                                                <span class="swal2-label">Female</span>
                                            </label>
                                            <label for="male" class="swal2-radio">
                                                <input type="radio" id="male" name="gender" value="Male">
                                                <span class="swal2-label">Male</span>
                                            </label>
                                        </div>
                                        <input id="firstname" class="swal2-input" placeholder="First Name*">
                                        <input id="lastname" class="swal2-input" placeholder="Last Name*">
                                        <input id="ccode" class="swal2-input" hidden value="${countryCode}">
                                        <input id="phone" class="swal2-input" readonly value="${phoneNumber}">
                                        <input id="email" class="swal2-input" placeholder="Email">
                                        <div>
                                            <p id="birthday-label" style="text-align: left; margin-bottom: -5px; color: #545454;">Birthday</p>
                                            <input id="birthday" type="date" class="swal2-input" placeholder="Birthday">
                                        </div>
                                        <select id="city" class="swal2-select">
                                            ${cityOptions_en}
                                        </select>
                                    </div>
                                `,
                                showCancelButton: false,
                                allowOutsideClick: false,
                                allowEscapeKey: false,
                                showConfirmButton: true,
                                confirmButtonText: 'Submit',
                                customClass: {
                                    container: 'scrollable-swal',
                                },
                                preConfirm: () => {
                                    // Handle form submission
                                    let language = '';
                                    if ($("#english-btn").hasClass("active")) {
                                        language = 'en';
                                    }
                                    if ($("#arabic-btn").hasClass("active")) {
                                        language = 'ar';
                                    }
                                    const firstname = document.querySelector('#firstname').value;
                                    const lastname = document.querySelector('#lastname').value;
                                    const city = document.querySelector('#city').value;
                                    const ccode = document.querySelector('#ccode').value;
                                    const phone = phoneNumber;
                                    const gender = document.querySelector('input[name="gender"]:checked')?.value;
                                    const birthday = document.querySelector('#birthday').value;
                                    const email = document.querySelector('#email').value;
                                    if (!firstname || !lastname || !phone) {
                                        Swal.showValidationMessage('Please fill in all required fields');
                                    } else {
                                        return [firstname, lastname, city, ccode, phone, gender, birthday, email, language];
                                    }
                                },
                                didOpen: () => {
                                    const popup = Swal.getPopup();
                                    popup.scrollTop = 0;
                                    const confirmButton = Swal.getConfirmButton();
                                    if (confirmButton) {
                                        confirmButton.style.backgroundColor = color;
                                    }

                                    $("#english-btn").click((e) => {
                                        e.preventDefault();
                                        $("#arabic-btn").removeClass("active");
                                        $("#english-btn").addClass("active");

                                        const firstname = document.querySelector('#firstname');
                                        const femaleRadioLabel = document.querySelector('.swal2-radio[for="female"]');
                                        const maleRadioLabel = document.querySelector('.swal2-radio[for="male"]');
                                        const lastname = document.querySelector('#lastname');
                                        const city = document.querySelector('#city');
                                        const birthday = document.querySelector('#birthday-label');
                                        const email = document.querySelector('#email');

                                        $('#swal2-form').css('direction', 'ltr');
                                        firstname.placeholder = 'First Name*';
                                        lastname.placeholder = 'Last Name*';
                                        femaleRadioLabel.innerHTML = `
                                            <input type="radio" id="female" name="gender" value="Female">
                                            <span class="swal2-label">Female</span>
                                        `;
                                        maleRadioLabel.innerHTML = `
                                            <input type="radio" id="male" name="gender" value="Male">
                                            <span class="swal2-label">Male</span>
                                        `;
                                        city.innerHTML = cityOptions_en;
                                        birthday.textContent = 'Birthday';
                                        birthday.style.cssText = "text-align: left; margin-bottom: -5px; color: #545454;";
                                        email.placeholder = 'Email';
                                    });

                                    $("#arabic-btn").click((e) => {
                                        e.preventDefault();
                                        $("#english-btn").removeClass("active");
                                        $("#arabic-btn").addClass("active");

                                        const firstname = document.querySelector('#firstname');
                                        const femaleRadioLabel = document.querySelector('.swal2-radio[for="female"]');
                                        const maleRadioLabel = document.querySelector('.swal2-radio[for="male"]');
                                        const lastname = document.querySelector('#lastname');
                                        const city = document.querySelector('#city');
                                        const birthday = document.querySelector('#birthday-label');
                                        const email = document.querySelector('#email');

                                        $('#swal2-form').css('direction', 'rtl');
                                        firstname.placeholder = '*الاسم الأول';
                                        lastname.placeholder = '*اسم العائلة';
                                        femaleRadioLabel.innerHTML = `
                                            <input type="radio" id="female" name="gender" value="Female">
                                            <span class="swal2-label">أنثى</span>
                                        `;
                                        maleRadioLabel.innerHTML = `
                                            <input type="radio" id="male" name="gender" value="Male">
                                            <span class="swal2-label">ذكر</span>
                                        `;
                                        city.innerHTML = cityOptions_ar;
                                        birthday.textContent = 'تاريخ الميلاد';
                                        birthday.style.cssText = "text-align: right; margin-bottom: -5px; color: #545454;";
                                        email.placeholder = 'البريد الإلكتروني';
                                    });

                                }
                            }) .then((result) => {
                                if (result.value) {
                                    $.ajax({
                                        url: "./assets/api/customer.php",
                                        type: 'POST',
                                        async: false,
                                        data: { request:'createCustomer', data: result.value },
                                        success: function (data) {
                                            if (data.status === 1) {
                                                const customer = data.customer_id;
                                                window.location = 'review?business=' + business + '&customer=' + customer;
                                            }
                                        }
                                    });
                                }
                            });
                        });
                    }
                }
            });
        }
    });
});

