window.onbeforeunload = function() {
    return confirm("Changes you made may not be saved.");
};

$(document).on("click","#cancel",function(e){
    window.history.back();
});

$(document).ready(function() {
    $("#country").change(function() {
        var html = ``;
        var country = $(this).val();
        $.ajax({
            url: "./assets/api/businesses.php",
            type: 'POST',
            data: {mode: 'GET_CITIES', country},
            success: function (data) {
                for (var i = 0; i < data.length; i++) {
                    let id = data[i]['id'];
                    let name = data[i]['name'];
                    html += `<option value=${id}>${name}</option>`
                }
                $('#city').html(html);
            }
        });
    });
});

$('#btnLogo').on('click', function(e) {
    e.preventDefault();
    var file_data = $('#logo').prop('files')[0];   
    var form_data = new FormData();                  
    form_data.append('logo', file_data);
    $.ajax({
        url: 'includes/logo.php',
        cache: false,
        contentType: false,
        processData: false,
        data: form_data,                         
        type: 'POST',
        success: function(data){
            $('#displayLogo').html(data);
        }
    });
});

$(document).on("click","#logodelete",function(e){
    e.preventDefault();
    $(this).parent().parent().parent().remove();
});

$('#btnBackground').on('click', function(e) {
    e.preventDefault();
    var file_data = $('#background').prop('files')[0];   
    var form_data = new FormData();                  
    form_data.append('background', file_data);
    $.ajax({
        url: 'includes/background.php',
        cache: false,
        contentType: false,
        processData: false,
        data: form_data,                         
        type: 'POST',
        success: function(data){
            $('#displayBackground').html(data);
        }
    });
});

$(document).on("click","#backgrounddelete",function(e){
    e.preventDefault();
    $(this).parent().parent().parent().remove();
});

$('#btnMenu').on('click', function(e) {
    e.preventDefault();
    var file_data = $('#menu').prop('files')[0];   
    var form_data = new FormData();                  
    form_data.append('menu', file_data);
    $.ajax({
        url: 'includes/menu.php',
        cache: false,
        contentType: false,
        processData: false,
        data: form_data,                         
        type: 'POST',
        success: function(data){
            $('#displayMenu').append(data);
        }
    });
});

$(document).on("click",".menudelete",function(e){
    e.preventDefault();
    $(this).parent().parent().remove();
});

$(document).on("click","#update",function(e){
    e.preventDefault();
    window.onbeforeunload = null;

    let businessid = $("#businessid").val();
    
    let name = $("#name").val();
    if(!name){
        $("#lblname").addClass("text-danger");
        $("#name").addClass("is-invalid");
        $("#feedbackname").text("This field is required!");
        $('html, body').animate({
            scrollTop: ($('#lblname').offset().top - 60)
        }, 500);
    } else{
        $("#lblname").removeClass("text-danger");
        $("#name").removeClass("is-invalid");
        $("#feedbackname").text("");
    }

    let email = $("#email").val();
    let validEmail = false;
    if(!email){
        $("#lblemail").addClass("text-danger");
        $("#email").addClass("is-invalid");
        $("#feedbackemail").text("This field is required!");
        if(name){
            $('html, body').animate({
                scrollTop: ($('#lblemail').offset().top - 60)
            }, 500);
        }
    } else{
        if(isEmail(email)){
            $("#lblemail").removeClass("text-danger");
            $("#email").removeClass("is-invalid");
            $("#feedbackemail").text("");
            validEmail = true;
        }
        else {
            $("#lblemail").addClass("text-danger");
            $("#email").addClass("is-invalid");
            $("#feedbackemail").text("This is not a valid email!");
            if(name){
                $('html, body').animate({
                    scrollTop: ($('#lblemail').offset().top - 60)
                }, 500);
            }
        } 
    }

    let mobile = $("#mobile").val();
    if(!mobile){
        $("#lblmobile").addClass("text-danger");
        $("#mobile").addClass("is-invalid");
        $("#feedbackmobile").text("This field is required!");
        if(name && validEmail){
            $('html, body').animate({
                scrollTop: ($('#lblmobile').offset().top - 60)
            }, 500);
        }
    } else{
        $("#lblmobile").removeClass("text-danger");
        $("#mobile").removeClass("is-invalid");
        $("#feedbackmobile").text("");
    }

    let c_date = $("#cdate").val();
    if(!c_date){
        $("#lblcdate").addClass("text-danger");
        $("#cdate").addClass("is-invalid");
        $("#feedbackcdate").text("This field is required!");
        if(name && validEmail && mobile){
            $('html, body').animate({
                scrollTop: ($('#lblcdate').offset().top - 60)
            }, 500);
        }
    } else{
        $("#lblcdate").removeClass("text-danger");
        $("#cdate").removeClass("is-invalid");
        $("#feedbackcdate").text("");
    }

    let role = $("#role").val();
    if(!role){
        $("#lblrole").addClass("text-danger");
        $("#role").addClass("is-invalid");
        $("#feedbackrole").text("This field is required!");
        if(name && validEmail && mobile && c_date){
            $('html, body').animate({
                scrollTop: ($('#lblrole').offset().top - 60)
            }, 500);
        }
    } else{
        $("#lblrole").removeClass("text-danger");
        $("#role").removeClass("is-invalid");
        $("#feedbackrole").text("");
    }
    
    let phone = $("#phone").val();
    let address = $("#address").val();
    let country = $("#country").val();
    let city = $("#city").val();
    let color = $("#color").val();

    let active = 0;
    if($("#active").prop("checked") === true){ active = 1; }

    let instagram = $("#instagram").val();
    let facebook = $("#facebook").val();
    let tiktok = $("#tiktok").val();
    let youtube = $("#youtube").val();
    let linkedin = $("#linkedin").val();
    let snapchat = $("#snapchat").val();
    let twitter = $("#twitter").val();

    let followus = $("#followus").val();
  
    let menu_link = $("#menu_link").val();

    let menu = '';
    if($("#txtmenu").is('*')){
        menu = $("#txtmenu").text();
        menu = menu.replace(/"/g, '');
    }

    let logo = '';
    if($("#txtlogo").is('*')){
        logo = $("#txtlogo").text();
        logo = logo.replace(/"/g, '');
    }

    let background = '';
    if($("#txtbackground").is('*')){
        background = $("#txtbackground").text();
        background = background.replace(/"/g, '');
    }
    
    if(name && validEmail && mobile && c_date && role){
        $.ajax({
            url: "./assets/api/businesses.php",
            type: 'POST',
            data: {mode: 'UPDATE_business', businessid, name, email, mobile, phone, address, country, city, color, c_date, role, active, instagram, facebook, linkedin, twitter, tiktok, youtube, snapchat, followus, menu_link, menu, logo, background},
            success: function (response) {
                window.history.back();
            }
        });
    }
});

function isEmail(email){
    let regex = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return regex.test(email);
}