$(document).ready(function() {
    $.ajax({
        url: "./assets/api/customers.php",
        type: 'POST',
        data: {mode: 'GET_customers'},
        success: function (data) {
            var transformedData = [];
            for (var i = 0; i < data.length; i++) {
                var row = data[i];
                var transformedRow = {
                    'firstname': row['firstname'],
                    'lastname': row['lastname'],
                    'email': row['email'],
                    'phone': row['phone'],
                    'gender': row['gender'],
                    'birthday': row['birthday'],
                    'city': row['city']
                };
                transformedData.push(transformedRow);
            }

            $('#datatable').DataTable({
                scrollX: true,
                data: transformedData,
                columns: [
                    { title: 'Firstname', data: 'firstname' },
                    { title: 'Lastname', data: 'lastname' },
                    { title: 'Email', data: 'email' },
                    { title: 'Phone', data: 'phone' },
                    { title: 'Gender', data: 'gender' },
                    { title: 'Birthday', data: 'birthday' },
                    { title: 'City', data: 'city' },
                ],
                dom: 'Bfrtip', // Add export buttons to the DataTable
                buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
            });
        }
    });
});