window.onbeforeunload = function() {
    return confirm("Changes you made may not be saved.");
};

$(document).ready(function () {
    $("#business").chosen();
});

$(document).on("click","#cancel",function(e){
    window.history.back();
});

$(document).on("click","#create",function(e){
    e.preventDefault();
    window.onbeforeunload = null;
    
    let firstname = $("#firstname").val();
    if(!firstname){
        $("#lblfirstname").addClass("text-danger");
        $("#firstname").addClass("is-invalid");
        $("#feedbackfirstname").text("This field is required!");
        $('html, body').animate({
            scrollTop: ($('#lblfirstname').offset().top - 60)
        }, 500);
    } else{
        $("#lblfirstname").removeClass("text-danger");
        $("#firstname").removeClass("is-invalid");
        $("#feedbackfirstname").text("");
    }

    let lastname = $("#lastname").val();
    if(!lastname){
        $("#lbllastname").addClass("text-danger");
        $("#lastname").addClass("is-invalid");
        $("#feedbacklastname").text("This field is required!");
        if(firstname){
            $('html, body').animate({
                scrollTop: ($('#lbllastname').offset().top - 60)
            }, 500);
        }
    } else{
        $("#lbllastname").removeClass("text-danger");
        $("#lastname").removeClass("is-invalid");
        $("#feedbacklastname").text("");
    }

    let username = $("#username").val();
    let validUsername = false;
    if(!username){
        $("#lblusername").addClass("text-danger");
        $("#username").addClass("is-invalid");
        $("#feedbackusername").text("This field is required!");
        if(firstname && lastname){
            $('html, body').animate({
                scrollTop: ($('#lblusername').offset().top - 60)
            }, 500);
        }
    } else{
        $.ajax({
            url: "./assets/api/managers.php",
            type: 'POST',
            async: false,
            data: {mode: 'CHECK_CREATE_username', username},
            success: function (response) {
                if(response == 'UNIQUE'){
                    $("#lblusername").removeClass("text-danger");
                    $("#username").removeClass("is-invalid");
                    $("#feedbackusername").text("");
                    validUsername = true;
                }
                if(response == 'EXIST'){
                    $("#lblusername").addClass("text-danger");
                    $("#username").addClass("is-invalid");
                    $("#feedbackusername").text("This username already exists!");
                    if(firstname && lastname){
                        $('html, body').animate({
                            scrollTop: ($('#lblusername').offset().top - 60)
                        }, 500);
                    }
                }
            }
        });
    }

    let email = $("#email").val();
    let validEmail = false;
    if(!email){
        $("#lblemail").addClass("text-danger");
        $("#email").addClass("is-invalid");
        $("#feedbackemail").text("This field is required!");
        if(firstname && lastname && validUsername){
            $('html, body').animate({
                scrollTop: ($('#lblemail').offset().top - 60)
            }, 500);
        }
    } else{
        if(isEmail(email)){
            $.ajax({
                url: "./assets/api/agents.php",
                type: 'POST',
                async: false,
                data: {mode: 'CHECK_CREATE_email', email},
                success: function (response) {
                    if(response == 'UNIQUE'){
                        $("#lblemail").removeClass("text-danger");
                        $("#email").removeClass("is-invalid");
                        $("#feedbackemail").text("");
                        validEmail = true;
                    }
                    if(response == 'EXIST'){
                        $("#lblemail").addClass("text-danger");
                        $("#email").addClass("is-invalid");
                        $("#feedbackemail").text("This email already exists!");
                        if(firstname && lastname && validUsername){
                            $('html, body').animate({
                                scrollTop: ($('#lblemail').offset().top - 60)
                            }, 500);
                        }
                    }
                }
            });
        }
        else {
            $("#lblemail").addClass("text-danger");
            $("#email").addClass("is-invalid");
            $("#feedbackemail").text("This is not a valid email!");
            if(firstname && lastname && validUsername){
                $('html, body').animate({
                    scrollTop: ($('#lblemail').offset().top - 60)
                }, 500);
            }
        } 
    }
    
    let password = $("#password").val();
    if(!password){
        $("#lblpassword").addClass("text-danger");
        $("#password").addClass("is-invalid");
        $("#feedbackpassword").text("This field is required!");
        if(firstname && lastname && validUsername && email){
            $('html, body').animate({
                scrollTop: ($('#lblpassword').offset().top - 60)
            }, 500);
        }
    } else{
        $("#lblpassword").removeClass("text-danger");
        $("#password").removeClass("is-invalid");
        $("#feedbackpassword").text("");
    }  

    let active = 0;
    if($("#active").prop("checked") === true){ active = 1; }

    let business = $("#business").val();
    
    if(firstname && lastname && validUsername && validEmail && password){
        $.ajax({
            url: "./assets/api/managers.php",
            type: 'POST',
            data: {mode: 'CREATE_manager', firstname, lastname, username, email, password, active, business},
            success: function (response) {
                window.history.back();
            }
        });
    }
});

function isEmail(email){
    let regex = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return regex.test(email);
}

function isPhone(phone){
    let regex = /^(961(3|70|71|76|78|79|81)|(03|70|71|76|78|79|81))\d{6}$/;
    return regex.test(phone);
}