<?php 
    
    include("../../../shared/common.php");
    $request = $_POST['request'];

    if($request == 'createCustomer'){
        $data = $_POST['data'];
        $firstname = $data[0]; 
        $lastname = $data[1];
        $city = !empty($data[2])?$data[2]:0;
        $ccode = $data[3];
        $phone = $data[4];
        $gender = $data[5];
        $birthday = !empty($data[6])?$data[6]:null;
        $email = !empty($data[7])?$data[7]:''; 
        $language = $data[8];   
        date_default_timezone_set('Asia/Beirut');
        $c_date = date('y-m-d H:i:s');
        $output = [];
        if(!empty($firstname) && !empty($lastname) && !empty($phone) && !empty($ccode) && !empty($language)){
            $query = "INSERT INTO customer(firstname, lastname, phone, birthday, email, gender, datetime, city, lang, ccode) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $con->prepare($query);
            $stmt->bind_param("sssssssiss", $firstname, $lastname, $phone, $birthday, $email, $gender, $c_date, $city, $language, $ccode);
            $result = $stmt->execute();
            if($result){ 
                $customerID = $stmt->insert_id;
                $output = [ 
                    'status' => 1,
                    'customer_id' => $customerID
                ]; 
            } else{ 
                $output = [ 
                    'status' => 0
                ]; 
            } 
        }
        header('Content-type: application/json');
        echo json_encode($output);
    }

    if($request == 'loadCustomer'){
        $customer = $_POST['customer'];
        $array = array();
        $query = "SELECT * FROM customer WHERE id=$customer";
        $result = $db->query($query);
        $count = mysqli_num_rows($result); 
        if($count) {
            $row = mysqli_fetch_assoc($result);
            array_push($array, $row);
        }
        header('Content-type: application/json');
        echo json_encode($array);
    }

    if($request == 'updateCustomer'){
        $data = $_POST['data'];
        $customer = $_POST['customer'];
        $firstname = $data[0]; 
        $lastname = $data[1];
        $city = !empty($data[2])?$data[2]:0;
        $gender = $data[5];
        $birthday = !empty($data[6])?$data[6]:null;
        $email = !empty($data[7])?$data[7]:''; 
        $language = $data[8];   
        date_default_timezone_set('Asia/Beirut');
        $c_date = date('y-m-d H:i:s');
        $output = "";
        if(!empty($firstname) && !empty($lastname) && !empty($language)){
            $query = "UPDATE customer SET firstname = ?, lastname = ?, birthday = ?, email = ?, gender = ?, datetime = ?, city = ?, lang = ? WHERE id = ?";
            $stmt = $con->prepare($query);
            $stmt->bind_param("ssssssisi", $firstname, $lastname, $birthday, $email, $gender, $c_date, $city, $language, $customer);
            $result = $stmt->execute();
            if($result){ 
                $output = "Done"; 
            }
        }
        header('Content-type: application/json');
        echo json_encode($output);
    }

?>